<?php ?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Venice.ai — Locked Identity Generator</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#0b0f14; color:#e8eef6; }
    .card { background:#121826; border:1px solid #1e2a3a; }
    .thumb { border-radius:.75rem; width:100%; height:auto; }
  </style>
</head>
<body>
<div class="container py-4">
  <h1 class="mb-3">Locked Identity Generator</h1>
  <p class="text-muted">This page always uses a fixed internal reference photo. Users can only change the <em>prompt</em>.</p>
  <div class="row g-4">
    <div class="col-lg-4">
      <div class="card p-3">
        <form id="genForm" class="vstack gap-3">
          <div>
            <label class="form-label">Prompt</label>
            <textarea class="form-control" id="prompt" rows="5" placeholder="e.g., same person wearing a navy suit, studio portrait lighting, neutral gray background"></textarea>
          </div>
          <button type="submit" class="btn btn-primary w-100">Generate</button>
        </form>
      </div>
      <div id="err" class="alert alert-danger mt-3 d-none" role="alert"></div>
      <div class="alert alert-secondary mt-3">
        <div class="small">Admin note: replace <code>fixed_ref.jpg</code> in the folder to update the identity. Users cannot upload new images.</div>
      </div>
    </div>
    <div class="col-lg-8"><div id="result"></div></div>
  </div>
</div>
<script>
function showError(msg){ const e=document.getElementById('err'); e.textContent=msg; e.classList.remove('d-none'); }
function clearError(){ document.getElementById('err').classList.add('d-none'); }
async function fetchJSON(url,opts={}){ const r=await fetch(url,opts); const t=await r.text(); if(!r.ok) throw new Error(t||('HTTP '+r.status)); try { return JSON.parse(t); } catch { throw new Error(t); } }

document.getElementById('genForm').addEventListener('submit', async (e) => {
  e.preventDefault(); clearError();
  const prompt = document.getElementById('prompt').value.trim();
  if (!prompt){ showError('Please enter a prompt.'); return; }
  try{
    const res = await fetchJSON('edit_fixed.php', { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ prompt }) });
    const b64 = res?.image; if(!b64){ showError('No image returned.'); return; }
    document.getElementById('result').innerHTML =
      `<div class="card p-2"><img class="thumb" src="data:image/png;base64,${b64}" alt="Result"><a class="btn btn-outline-light btn-sm mt-2" href="data:image/png;base64,${b64}" download="locked_identity.png">Download</a></div>`;
  } catch(err){ console.error(err); showError('Error: ' + err.message); }
});
</script>
</body>
</html>