<?php
// ===== Venice API =====
const VENICE_API_KEY  = 'c5HJTclK01-HSaWbjl-L5QdXO85gBmZtFhJnvdEuNQ';
const VENICE_API_BASE = 'https://api.venice.ai/api/v1';

// ===== Hard-coded reference image path (relative to this folder) =====
const REF_IMAGE_PATH = __DIR__ . '/fixed_ref.jpg'; // change name if needed

// --- Venice helpers ---
function venice_api_call_binary(string $endpoint, array $jsonPayload, array $headersExtra = []) {
  $url = rtrim(VENICE_API_BASE, '/') . '/' . ltrim($endpoint, '/');
  $ch = curl_init($url);
  $headers = array_merge([
    'Authorization: Bearer ' . VENICE_API_KEY,
    'Content-Type: application/json',
    'Accept: image/png'
  ], $headersExtra);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 120,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($jsonPayload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
  ]);
  $res  = curl_exec($ch);
  $err  = curl_error($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($err) return ['ok' => false, 'status' => $code ?: 0, 'error' => $err];
  if ($code >= 200 && $code < 300) return ['ok' => true, 'status' => $code, 'data' => $res];
  return ['ok' => false, 'status' => $code, 'error' => $res];
}

function venice_api_call_json(string $endpoint, array $payload = null, string $method = 'GET') {
  $url = rtrim(VENICE_API_BASE, '/') . '/' . ltrim($endpoint, '/');
  $ch = curl_init($url);
  $headers = [
    'Authorization: Bearer ' . VENICE_API_KEY,
    'Accept: application/json'
  ];
  $opts = [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 90,
  ];
  if ($method !== 'GET') {
    $opts[CURLOPT_CUSTOMREQUEST] = $method;
    $headers[] = 'Content-Type: application/json';
    $opts[CURLOPT_HTTPHEADER] = $headers;
    $opts[CURLOPT_POSTFIELDS] = json_encode($payload ?? [], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
  }
  curl_setopt_array($ch, $opts);
  $res  = curl_exec($ch);
  $err  = curl_error($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($err) return ['ok' => false, 'status' => $code ?: 0, 'error' => $err];
  $json = json_decode($res, true);
  if ($code >= 200 && $code < 300) return ['ok' => true, 'status' => $code, 'data' => $json ];
  return ['ok' => false, 'status' => $code, 'error' => $json ?: $res];
}

// --- Small helper ---
function load_file_base64(string $path) {
  if (!file_exists($path)) return [null, 'File not found: ' . $path];
  $bytes = @file_get_contents($path);
  if ($bytes === false) return [null, 'Failed to read: ' . $path];
  return [base64_encode($bytes), null];
}
?>