<?php
header('Content-Type: application/json');
header('Cache-Control: no-store');
require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405); echo json_encode(['error' => 'Method not allowed']); exit;
}
$input = json_decode(file_get_contents('php://input'), true) ?? [];
$prompt = trim((string)($input['prompt'] ?? ''));
if ($prompt === '') { http_response_code(400); echo json_encode(['error' => 'Prompt is required']); exit; }

$payload = [
  'model'           => $input['model'] ?? 'hidream',
  'prompt'          => $prompt,
  'negative_prompt' => $input['negative_prompt'] ?? null,
  'style_preset'    => $input['style_preset'] ?? null,
  'width'           => max(64, min(1280, (int)($input['width'] ?? 1024))),
  'height'          => max(64, min(1280, (int)($input['height'] ?? 1024))),
  'steps'           => max(1, min(50, (int)($input['steps'] ?? 20))),
  'cfg_scale'       => (float)($input['cfg_scale'] ?? 7.5),
  'variants'        => max(1, min(4, (int)($input['variants'] ?? 1))),
  'safe_mode'       => isset($input['safe_mode']) ? (bool)$input['safe_mode'] : true,
  'format'          => in_array(($input['format'] ?? 'webp'), ['webp','png','jpeg'], true) ? $input['format'] : 'webp',
  'seed'            => (int)($input['seed'] ?? 0),
  'return_binary'   => false
];
$payload = array_filter($payload, fn($v) => $v !== null);
$res = venice_api_call_json('/image/generate', $payload, 'POST');

if (!$res['ok']) {
  http_response_code($res['status'] ?: 500);
  $msg = is_array($res['error']) ? json_encode($res['error']) : $res['error'];
  echo json_encode(['error' => $msg, 'status' => $res['status']]); exit;
}
echo json_encode($res['data']);
?>