<?php
// Accepts multipart/form-data with fields: image_file (file), prompt (text)
header('Content-Type: application/json');
header('Cache-Control: no-store');
require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405); echo json_encode(['error' => 'Method not allowed']); exit;
}
$prompt = isset($_POST['prompt']) ? trim($_POST['prompt']) : '';
if ($prompt === '') { http_response_code(400); echo json_encode(['error' => 'Prompt is required']); exit; }

if (!isset($_FILES['image_file']) || $_FILES['image_file']['error'] !== UPLOAD_ERR_OK) {
  http_response_code(400); echo json_encode(['error' => 'image_file is required']); exit;
}

$tmp = $_FILES['image_file']['tmp_name'];
$bytes = file_get_contents($tmp);
if ($bytes === false) { http_response_code(400); echo json_encode(['error' => 'Failed to read uploaded file']); exit; }
$base64 = base64_encode($bytes);

// Build JSON body for /image/edit
$payload = [
  'prompt' => $prompt,
  'image'  => $base64
];

$res = venice_api_call_binary('/image/edit', $payload);
if (!$res['ok']) {
  http_response_code($res['status'] ?: 500);
  $msg = is_string($res['error']) ? $res['error'] : 'Unknown error';
  echo json_encode(['error' => $msg, 'status' => $res['status']]); exit;
}

// $res['data'] is raw PNG bytes. Return base64 so the browser can display easily.
$out_b64 = base64_encode($res['data']);
echo json_encode(['image' => $out_b64, 'format' => 'png']);
?>