<?php ?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dating Profiles Generator</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#0b0f14; color:#e8eef6; }
    .card { background:#121826; border:1px solid #1e2a3a; }
    .form-control { background:#0f1623; color:#e8eef6; border-color:#1e2a3a; }
    .thumb{border-radius:.75rem; width:100%; height:auto;}
  </style>
</head>
<body>
  <div class="container py-4">
    <div class="d-flex align-items-center justify-content-between mb-3">
      <h1 class="h4 mb-0">Dating Profiles Generator</h1>
      <div class="d-flex gap-2">
        <a class="btn btn-sm btn-outline-light" href="index.php">Image Gen</a>
        <a class="btn btn-sm btn-primary" href="profiles_list.php">Profiles Gallery</a>
      </div>
    </div>
    <div class="row g-4">
      <div class="col-lg-4">
        <div class="card p-3">
          <form id="genForm" class="vstack gap-3">
            <div>
              <label class="form-label">Profile style (hint to LLM)</label>
              <input class="form-control" name="style" placeholder="friendly, professional, modern">
            </div>
            <div>
              <label class="form-label">Portrait vibe (hint to image)</label>
              <input class="form-control" name="vibe" placeholder="warm, confident, genuine">
            </div>
            <button class="btn btn-primary">Generate & Save</button>
          </form>
        </div>
      </div>
      <div class="col-lg-8" id="resultCol"></div>
    </div>
  </div>
<script>
document.getElementById('genForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  const res = await fetch('profiles_generate.php', { method:'POST', body: fd });
  const out = document.getElementById('resultCol');
  if (!res.ok) {
    const t = await res.text();
    out.innerHTML = `<div class="alert alert-danger">Error: ${t.replace(/</g,'&lt;')}</div>`;
    return;
  }
  const j = await res.json();
  if (!j.ok) {
    out.innerHTML = `<div class="alert alert-danger">Error: ${JSON.stringify(j)}</div>`;
    return;
  }
  out.innerHTML = `
    <div class="card p-3">
      <div class="row g-3 align-items-center">
        <div class="col-md-4">
          <img class="thumb" src="${j.image_url}" alt="portrait">
        </div>
        <div class="col-md-8">
          <h5 class="mb-1">${j.profile.name}, ${j.profile.age}</h5>
          <div class="text-muted small mb-2">${j.profile.location} • ${j.profile.occupation}</div>
          <p class="mb-2">${j.profile.bio}</p>
          <details class="mb-2"><summary>Desires</summary><div class="mt-1">${j.profile.desires}</div></details>
          <div><b>Seeking:</b> ${j.profile.seeking}</div>
          <div class="mt-3">
            <a class="btn btn-sm btn-success" href="profiles_list.php">Open Gallery</a>
          </div>
        </div>
      </div>
    </div>`;
});
</script>
</body>
</html>
